/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.ProdosVirtualDisk;
import jace.hardware.massStorage.SubNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileNode
extends DiskNode {
    public int fileType = 0;
    public int loadAddress = 0;
    public static int SEEDLING_MAX_SIZE = 512;
    public static int SAPLING_MAX_SIZE = 131072;

    @Override
    public DiskNode.EntryType getType() {
        long fileSize = this.getPhysicalFile().length();
        if (fileSize < (long)SEEDLING_MAX_SIZE) {
            this.setType(DiskNode.EntryType.SEEDLING);
            return DiskNode.EntryType.SEEDLING;
        }
        if (fileSize < (long)SAPLING_MAX_SIZE) {
            this.setType(DiskNode.EntryType.SAPLING);
            return DiskNode.EntryType.SAPLING;
        }
        this.setType(DiskNode.EntryType.TREE);
        return DiskNode.EntryType.TREE;
    }

    @Override
    public void setName(String name) {
        String[] parts = name.split("\\.");
        FileType t = null;
        int offset = 0;
        if (parts.length > 1) {
            String extension = parts[parts.length - 1].toUpperCase();
            String[] extParts = extension.split("#");
            if (extParts.length == 2) {
                offset = Integer.parseInt(extParts[1], 16);
                extension = extParts[0];
            }
            try {
                t = FileType.valueOf(extension);
            }
            catch (IllegalArgumentException ex) {
                System.out.println("Not sure what extension " + extension + " is!");
            }
            name = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                name = name + (i > 0 ? "." + parts[i] : parts[i]);
            }
            if (extParts[extParts.length - 1].equals("SYSTEM")) {
                name = name + ".SYSTEM";
            }
        }
        if (t == null) {
            t = FileType.UNKNOWN;
        }
        if (offset == 0) {
            offset = t.defaultLoadAddress;
        }
        this.fileType = t.code;
        this.loadAddress = offset;
        super.setName(name);
    }

    public FileNode(ProdosVirtualDisk ownerFilesystem, File file) throws IOException {
        this.setOwnerFilesystem(ownerFilesystem);
        this.setPhysicalFile(file);
    }

    @Override
    public void doDeallocate() {
    }

    @Override
    public void doAllocate() throws IOException {
        int dataBlocks = (int)(this.getPhysicalFile().length() / 512L + 1L);
        int treeBlocks = 0;
        treeBlocks = dataBlocks > 1 && dataBlocks < 257 ? 1 : 1 + dataBlocks / 256;
        for (int i = 1; i < dataBlocks + treeBlocks; ++i) {
            new SubNode(i, this);
        }
    }

    @Override
    public void doRefresh() {
    }

    @Override
    public void readBlock(int block, byte[] buffer) throws IOException {
        switch (this.getType()) {
            case SEEDLING: {
                this.readFile(buffer, 0);
                break;
            }
            case SAPLING: {
                if (block > 0) {
                    this.readFile(buffer, block - 1);
                    break;
                }
                this.generateIndex(buffer, 0, 256);
                break;
            }
            case TREE: {
                int dataBlocks = (int)(this.getPhysicalFile().length() / 512L + 1L);
                int treeBlocks = dataBlocks / 256;
                if (block == 0) {
                    this.generateIndex(buffer, 0, treeBlocks);
                    break;
                }
                if (block < treeBlocks) {
                    int start = treeBlocks + (block - 256);
                    int end = Math.min(start + 256, treeBlocks);
                    this.generateIndex(buffer, treeBlocks, end);
                    break;
                }
                this.readFile(buffer, block - treeBlocks);
            }
        }
    }

    private void readFile(byte[] buffer, int start) throws IOException {
        FileInputStream f = new FileInputStream(this.physicalFile);
        f.skip(start * 512);
        f.read(buffer, 0, 512);
        f.close();
    }

    private void generateIndex(byte[] buffer, int indexStart, int indexLimit) {
        int pos = 0;
        for (int i = indexStart; pos < 256 && i < indexLimit && i < this.additionalNodes.size(); ++i, ++pos) {
            buffer[pos] = (byte)(((DiskNode)this.additionalNodes.get((int)i)).baseBlock & 0xFF);
            buffer[pos + 256] = (byte)(((DiskNode)this.additionalNodes.get((int)i)).baseBlock >> 8 & 0xFF);
        }
    }

    public static enum FileType {
        UNKNOWN(0, 0),
        ADB(25, 0),
        AWP(26, 0),
        ASP(27, 0),
        BAD(1, 0),
        BIN(6, 768),
        CLASS(237, 0),
        BAS(252, 2049),
        CMD(240, 0),
        INT(250, 2049),
        IVR(251, 0),
        PAS(239, 0),
        REL(254, 0),
        SHK(224, 32770),
        SDK(224, 32770),
        SYS(255, 8192),
        SYSTEM(255, 8192),
        TXT(4, 0),
        U01(241, 0),
        U02(242, 0),
        U03(243, 0),
        U04(244, 0),
        U05(245, 0),
        U06(246, 0),
        U07(247, 0),
        U08(248, 0),
        VAR(253, 0);

        public int code = 0;
        public int defaultLoadAddress = 0;

        private FileType(int code, int addr) {
            this.code = code;
            this.defaultLoadAddress = addr;
        }
    }
}

